/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

public class BlockOption {
    private int szx;
    private boolean m;
    private int num;

    public BlockOption() {
    }

    public BlockOption(int szx, boolean m, int num) {
        this.setSzx(szx);
        this.setM(m);
        this.setNum(num);
    }

    public BlockOption(BlockOption origin) {
        if (origin == null) {
            throw new NullPointerException();
        }
        this.setSzx(origin.getSzx());
        this.setM(origin.isM());
        this.setNum(origin.getNum());
    }

    public BlockOption(byte[] value) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value.length > 3) {
            throw new IllegalArgumentException("Block option's length must at most 3 bytes inclusive");
        }
        if (value.length == 0) {
            this.szx = 0;
            this.m = false;
            this.num = 0;
        } else {
            byte end = value[value.length - 1];
            this.szx = end & 7;
            this.m = (end >> 3 & 1) == 1;
            this.num = (end & 0xFF) >> 4;
            int i = 1;
            while (i < value.length) {
                this.num += (value[value.length - i - 1] & 0xFF) << i * 8 - 4;
                ++i;
            }
        }
    }

    public int getSzx() {
        return this.szx;
    }

    public void setSzx(int szx) {
        if (szx < 0 || 7 < szx) {
            throw new IllegalArgumentException("Block option's szx must be between 0 and 7 inclusive");
        }
        this.szx = szx;
    }

    public int getSize() {
        return 1 << 4 + this.szx;
    }

    public boolean isM() {
        return this.m;
    }

    public void setM(boolean m) {
        this.m = m;
    }

    public int getNum() {
        return this.num;
    }

    public void setNum(int num) {
        if (num < 0 || 1048575 < num) {
            throw new IllegalArgumentException("Block option's num must be between 0 and 524288 inclusive");
        }
        this.num = num;
    }

    public byte[] getValue() {
        int last = this.szx | (this.m ? 8 : 0);
        if (this.num == 0 && !this.m && this.szx == 0) {
            return new byte[0];
        }
        if (this.num < 16) {
            return new byte[]{(byte)(last | this.num << 4)};
        }
        if (this.num < 4096) {
            return new byte[]{(byte)(this.num >> 4), (byte)(last | this.num << 4)};
        }
        return new byte[]{(byte)(this.num >> 12), (byte)(this.num >> 4), (byte)(last | this.num << 4)};
    }

    public int getOffset() {
        return this.num * BlockOption.szx2Size(this.szx);
    }

    public String toString() {
        return String.format("(szx=%d/%d, m=%b, num=%d)", this.szx, BlockOption.szx2Size(this.szx), this.m, this.num);
    }

    public boolean equals(Object o) {
        if (!(o instanceof BlockOption)) {
            return false;
        }
        BlockOption block = (BlockOption)o;
        return this.szx == block.szx && this.num == block.num && this.m == block.m;
    }

    public static int size2Szx(int blockSize) {
        if (blockSize >= 1024) {
            return 6;
        }
        if (blockSize <= 16) {
            return 0;
        }
        int maxOneBit = Integer.highestOneBit(blockSize);
        return Integer.numberOfTrailingZeros(maxOneBit) - 4;
    }

    public static int szx2Size(int szx) {
        if (szx <= 0) {
            return 16;
        }
        if (szx >= 6) {
            return 1024;
        }
        return 1 << szx + 4;
    }
}

