/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.network.InMemoryMessageExchangeStore;
import org.eclipse.californium.core.network.Matcher;
import org.eclipse.californium.core.network.MessageExchangeStore;
import org.eclipse.californium.core.network.config.NetworkConfig;

public abstract class BaseMatcher
implements Matcher {
    private static final Logger LOG = Logger.getLogger(BaseMatcher.class.getName());
    protected final NetworkConfig config;
    protected boolean running = false;
    protected MessageExchangeStore exchangeStore;

    public BaseMatcher(NetworkConfig config) {
        if (config == null) {
            throw new NullPointerException("Config must not be null");
        }
        this.config = config;
    }

    @Override
    public final synchronized void setMessageExchangeStore(MessageExchangeStore store) {
        if (this.running) {
            throw new IllegalStateException("MessageExchangeStore can only be set on stopped Matcher");
        }
        if (store == null) {
            throw new NullPointerException("Message exchange store must not be null");
        }
        this.exchangeStore = store;
    }

    protected final void assertMessageExchangeStoreIsSet() {
        if (this.exchangeStore == null) {
            LOG.log(Level.CONFIG, "no MessageExchangeStore set, using default {0}", InMemoryMessageExchangeStore.class.getName());
            this.exchangeStore = new InMemoryMessageExchangeStore(this.config);
        }
    }

    @Override
    public synchronized void start() {
        if (!this.running) {
            this.assertMessageExchangeStoreIsSet();
            this.exchangeStore.start();
            this.running = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.running) {
            this.exchangeStore.stop();
            this.clear();
            this.running = false;
        }
    }

    @Override
    public void clear() {
    }
}

