/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.config;

import org.eclipse.californium.core.network.config.NetworkConfig;

public class NetworkConfigDefaults {
    public static final int DEFAULT_MAX_RESOURCE_BODY_SIZE = 2048;
    public static final int DEFAULT_BLOCKWISE_STATUS_LIFETIME = 30000;

    public static void setDefaults(NetworkConfig config) {
        int CORES = Runtime.getRuntime().availableProcessors();
        String OS = System.getProperty("os.name");
        boolean WINDOWS = OS.startsWith("Windows");
        config.setInt("MAX_ACTIVE_PEERS", 500000);
        config.setLong("MAX_PEER_INACTIVITY_PERIOD", 129600L);
        config.setInt("COAP_PORT", 5683);
        config.setInt("COAP_SECURE_PORT", 5684);
        config.setInt("ACK_TIMEOUT", 2000);
        config.setFloat("ACK_RANDOM_FACTOR", 1.5f);
        config.setFloat("ACK_TIMEOUT_SCALE", 2.0f);
        config.setInt("MAX_RETRANSMIT", 4);
        config.setLong("EXCHANGE_LIFETIME", 247000L);
        config.setLong("NON_LIFETIME", 145000L);
        config.setLong("MAX_TRANSMIT_WAIT", 93000L);
        config.setInt("NSTART", 1);
        config.setInt("LEISURE", 5000);
        config.setFloat("PROBING_RATE", 1.0f);
        config.setBoolean("USE_RANDOM_MID_START", true);
        config.setInt("TOKEN_SIZE_LIMIT", 8);
        config.setInt("PREFERRED_BLOCK_SIZE", 512);
        config.setInt("MAX_MESSAGE_SIZE", 1024);
        config.setInt("MAX_RESOURCE_BODY_SIZE", 2048);
        config.setInt("BLOCKWISE_STATUS_LIFETIME", 600000);
        config.setLong("NOTIFICATION_CHECK_INTERVAL", 86400000L);
        config.setInt("NOTIFICATION_CHECK_INTERVAL_COUNT", 100);
        config.setLong("NOTIFICATION_REREGISTRATION_BACKOFF", 2000L);
        config.setBoolean("USE_CONGESTION_CONTROL", false);
        config.setString("CONGESTION_CONTROL_ALGORITHM", "Cocoa");
        config.setInt("PROTOCOL_STAGE_THREAD_COUNT", CORES);
        config.setInt("NETWORK_STAGE_RECEIVER_THREAD_COUNT", WINDOWS ? CORES : 1);
        config.setInt("NETWORK_STAGE_SENDER_THREAD_COUNT", WINDOWS ? CORES : 1);
        config.setInt("UDP_CONNECTOR_DATAGRAM_SIZE", 2048);
        config.setInt("UDP_CONNECTOR_RECEIVE_BUFFER", 0);
        config.setInt("UDP_CONNECTOR_SEND_BUFFER", 0);
        config.setInt("UDP_CONNECTOR_OUT_CAPACITY", Integer.MAX_VALUE);
        config.setString("DEDUPLICATOR", "DEDUPLICATOR_MARK_AND_SWEEP");
        config.setLong("MARK_AND_SWEEP_INTERVAL", 10000L);
        config.setInt("CROP_ROTATION_PERIOD", 2000);
        config.setBoolean("USE_STRICT_RESPONSE_MATCHING", false);
        config.setInt("HTTP_PORT", 8080);
        config.setInt("HTTP_SERVER_SOCKET_TIMEOUT", 100000);
        config.setInt("HTTP_SERVER_SOCKET_BUFFER_SIZE", 8192);
        config.setInt("HTTP_CACHE_RESPONSE_MAX_AGE", 86400);
        config.setInt("HTTP_CACHE_SIZE", 32);
        config.setString("HEALTH_STATUS_PRINT_LEVEL", "FINEST");
        config.setInt("HEALTH_STATUS_INTERVAL", 60);
        config.setInt("TCP_CONNECTION_IDLE_TIMEOUT", 10);
        config.setInt("TCP_WORKER_THREADS", 1);
        config.setInt("TCP_CONNECT_TIMEOUT", 10000);
    }

    private NetworkConfigDefaults() {
    }
}

