/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.Deduplicator;

public class CropRotation
implements Deduplicator {
    private static final Logger LOGGER = Logger.getLogger(CropRotation.class.getCanonicalName());
    private boolean running = false;
    private ScheduledExecutorService executor;
    private ExchangeMap[] maps;
    private int first;
    private int second;
    private long period;
    private Rotation rotation = new Rotation();

    public CropRotation(NetworkConfig config) {
        this.maps = new ExchangeMap[3];
        this.maps[0] = new ExchangeMap();
        this.maps[1] = new ExchangeMap();
        this.maps[2] = new ExchangeMap();
        this.first = 0;
        this.second = 1;
        this.period = config.getInt("CROP_ROTATION_PERIOD");
    }

    @Override
    public synchronized void start() {
        if (!this.running) {
            if (this.executor == null || this.executor.isShutdown()) {
                this.executor = Executors.newSingleThreadScheduledExecutor(new Utils.DaemonThreadFactory("Deduplicator"));
            }
            this.rotation.schedule();
            this.running = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.running) {
            this.rotation.cancel();
            this.executor.shutdown();
            this.clear();
            this.running = false;
        }
    }

    @Override
    public Exchange findPrevious(Exchange.KeyMID key, Exchange exchange) {
        int f = this.first;
        int s = this.second;
        Exchange prev = this.maps[f].putIfAbsent(key, exchange);
        if (prev != null || f == s) {
            return prev;
        }
        prev = this.maps[s].putIfAbsent(key, exchange);
        return prev;
    }

    @Override
    public Exchange find(Exchange.KeyMID key) {
        int f = this.first;
        int s = this.second;
        Exchange prev = (Exchange)this.maps[f].get(key);
        if (prev != null || f == s) {
            return prev;
        }
        prev = (Exchange)this.maps[s].get(key);
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ExchangeMap[] exchangeMapArray = this.maps;
        synchronized (this.maps) {
            this.maps[0].clear();
            this.maps[1].clear();
            this.maps[2].clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isEmpty() {
        ExchangeMap[] exchangeMapArray = this.maps;
        int n = this.maps.length;
        int n2 = 0;
        while (n2 < n) {
            ExchangeMap map = exchangeMapArray[n2];
            if (!map.isEmpty()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static class ExchangeMap
    extends ConcurrentHashMap<Exchange.KeyMID, Exchange> {
        private static final long serialVersionUID = 1504940670839294042L;

        private ExchangeMap() {
        }
    }

    private class Rotation
    implements Runnable {
        private ScheduledFuture<?> future;

        private Rotation() {
        }

        @Override
        public void run() {
            try {
                try {
                    this.rotation();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Exception in Crop-Rotation algorithm", t);
                    try {
                        this.schedule();
                    }
                    catch (Throwable t2) {
                        LOGGER.log(Level.WARNING, "Exception while scheduling Crop-Rotation algorithm", t2);
                    }
                }
            }
            finally {
                try {
                    this.schedule();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Exception while scheduling Crop-Rotation algorithm", t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rotation() {
            ExchangeMap[] exchangeMapArray = CropRotation.this.maps;
            synchronized (exchangeMapArray) {
                int third = CropRotation.this.first;
                CropRotation.this.first = CropRotation.this.second;
                CropRotation.this.second = (CropRotation.this.second + 1) % 3;
                CropRotation.this.maps[third].clear();
            }
        }

        private void schedule() {
            if (!CropRotation.this.executor.isShutdown()) {
                LOGGER.log(Level.FINE, "CR schedules in {0} ms", CropRotation.this.period);
                this.future = CropRotation.this.executor.schedule(this, CropRotation.this.period, TimeUnit.MILLISECONDS);
            }
        }

        private void cancel() {
            if (this.future != null) {
                this.future.cancel(true);
            }
        }
    }
}

