/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.OptionSet;

public abstract class Message {
    protected static final Logger LOGGER = Logger.getLogger(Message.class.getCanonicalName());
    public static final int NONE = -1;
    private CoAP.Type type;
    private int mid = -1;
    private byte[] token;
    private OptionSet options;
    private byte[] payload;
    private InetAddress destination;
    private InetAddress source;
    private int destinationPort;
    private int sourcePort;
    private boolean acknowledged;
    private boolean rejected;
    private boolean canceled;
    private boolean timedOut;
    private boolean duplicate;
    private byte[] bytes;
    private List<MessageObserver> messageObservers;
    private long timestamp;

    protected Message() {
    }

    public Message(CoAP.Type type) {
        this.type = type;
    }

    public CoAP.Type getType() {
        return this.type;
    }

    public Message setType(CoAP.Type type) {
        this.type = type;
        return this;
    }

    public boolean isConfirmable() {
        return this.getType() == CoAP.Type.CON;
    }

    public Message setConfirmable(boolean con) {
        this.setType(con ? CoAP.Type.CON : CoAP.Type.NON);
        return this;
    }

    public abstract int getRawCode();

    public int getMID() {
        return this.mid;
    }

    public Message setMID(int mid) {
        if (mid >= 65536 || mid < -1) {
            throw new IllegalArgumentException("The MID must be a 16-bit number between 0 and 65535 inclusive but was " + mid);
        }
        this.mid = mid;
        return this;
    }

    public void removeMID() {
        this.setMID(-1);
    }

    public boolean hasEmptyToken() {
        return this.token == null || this.token.length == 0;
    }

    public byte[] getToken() {
        return this.token;
    }

    public String getTokenString() {
        return Utils.toHexString(this.getToken());
    }

    public Message setToken(byte[] token) {
        if (token != null && token.length > 8) {
            throw new IllegalArgumentException("Token length must be between 0 and 8 inclusive");
        }
        this.token = token;
        return this;
    }

    public OptionSet getOptions() {
        if (this.options == null) {
            this.options = new OptionSet();
        }
        return this.options;
    }

    public Message setOptions(OptionSet options) {
        this.options = new OptionSet(options);
        return this;
    }

    public int getPayloadSize() {
        return this.payload == null ? 0 : this.payload.length;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String getPayloadString() {
        if (this.payload == null) {
            return "";
        }
        return new String(this.payload, CoAP.UTF8_CHARSET);
    }

    protected String getPayloadTracingString() {
        if (this.payload == null || this.payload.length == 0) {
            return "no payload";
        }
        boolean text = true;
        byte[] byArray = this.payload;
        int n = this.payload.length;
        int n2 = 0;
        block3: while (n2 < n) {
            byte b = byArray[n2];
            if (32 > b) {
                switch (b) {
                    case 9: 
                    case 10: 
                    case 13: {
                        break;
                    }
                    default: {
                        text = false;
                        break block3;
                    }
                }
            }
            ++n2;
        }
        if (text) {
            CharsetDecoder decoder = CoAP.UTF8_CHARSET.newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPORT);
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            ByteBuffer in = ByteBuffer.wrap(this.payload);
            CharBuffer out = CharBuffer.allocate(24);
            CoderResult result = decoder.decode(in, out, true);
            decoder.flush(out);
            out.flip();
            if (CoderResult.OVERFLOW == result) {
                return "\"" + out + "\".. " + this.payload.length + " bytes";
            }
            if (!result.isError()) {
                return "\"" + out + "\"";
            }
        }
        return Utils.toHexText(this.payload, 256);
    }

    public Message setPayload(String payload) {
        if (payload == null) {
            this.payload = null;
        } else {
            this.setPayload(payload.getBytes(CoAP.UTF8_CHARSET));
        }
        return this;
    }

    public Message setPayload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public InetAddress getDestination() {
        return this.destination;
    }

    public Message setDestination(InetAddress destination) {
        this.destination = destination;
        return this;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public Message setDestinationPort(int destinationPort) {
        this.destinationPort = destinationPort;
        return this;
    }

    public InetAddress getSource() {
        return this.source;
    }

    public void setSource(InetAddress source) {
        this.source = source;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(int sourcePort) {
        this.sourcePort = sourcePort;
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public void setAcknowledged(boolean acknowledged) {
        this.acknowledged = acknowledged;
        if (acknowledged) {
            for (MessageObserver handler : this.getMessageObservers()) {
                handler.onAcknowledgement();
            }
        }
    }

    public boolean isRejected() {
        return this.rejected;
    }

    public void setRejected(boolean rejected) {
        this.rejected = rejected;
        if (rejected) {
            for (MessageObserver handler : this.getMessageObservers()) {
                handler.onReject();
            }
        }
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
        if (timedOut) {
            for (MessageObserver observer : this.getMessageObservers()) {
                observer.onTimeout();
            }
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
        if (canceled) {
            for (MessageObserver handler : this.getMessageObservers()) {
                handler.onCancel();
            }
        }
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public boolean hasBlock(BlockOption block2) {
        return this.getPayloadSize() > 0 && block2.getOffset() < this.getPayloadSize();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void cancel() {
        this.setCanceled(true);
    }

    public void retransmitting() {
        for (MessageObserver observer : this.getMessageObservers()) {
            try {
                observer.onRetransmission();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Faulty MessageObserver for retransmitting events.", e);
            }
        }
    }

    public List<MessageObserver> getMessageObservers() {
        if (this.messageObservers == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.messageObservers);
    }

    public void addMessageObserver(MessageObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (this.messageObservers == null) {
            this.initMessageObserverList();
        }
        this.messageObservers.add(observer);
    }

    public void addMessageObservers(List<MessageObserver> observers) {
        if (observers == null) {
            throw new NullPointerException();
        }
        if (this.messageObservers == null) {
            this.initMessageObserverList();
        }
        this.messageObservers.addAll(observers);
    }

    public void removeMessageObserver(MessageObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (this.messageObservers != null) {
            this.messageObservers.remove(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMessageObserverList() {
        Message message = this;
        synchronized (message) {
            if (this.messageObservers == null) {
                this.messageObservers = new CopyOnWriteArrayList<MessageObserver>();
            }
        }
    }
}

