/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

public final class OptionNumberRegistry {
    public static final int UNKNOWN = -1;
    public static final int RESERVED_0 = 0;
    public static final int IF_MATCH = 1;
    public static final int URI_HOST = 3;
    public static final int ETAG = 4;
    public static final int IF_NONE_MATCH = 5;
    public static final int URI_PORT = 7;
    public static final int LOCATION_PATH = 8;
    public static final int URI_PATH = 11;
    public static final int CONTENT_FORMAT = 12;
    public static final int MAX_AGE = 14;
    public static final int URI_QUERY = 15;
    public static final int ACCEPT = 17;
    public static final int LOCATION_QUERY = 20;
    public static final int PROXY_URI = 35;
    public static final int PROXY_SCHEME = 39;
    public static final int SIZE1 = 60;
    public static final int RESERVED_1 = 128;
    public static final int RESERVED_2 = 132;
    public static final int RESERVED_3 = 136;
    public static final int RESERVED_4 = 140;
    public static final int OBSERVE = 6;
    public static final int BLOCK2 = 23;
    public static final int BLOCK1 = 27;
    public static final int SIZE2 = 28;

    public static optionFormats getFormatByNr(int optionNumber) {
        switch (optionNumber) {
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 14: 
            case 17: 
            case 23: 
            case 27: 
            case 28: 
            case 60: {
                return optionFormats.INTEGER;
            }
            case 3: 
            case 8: 
            case 11: 
            case 15: 
            case 20: 
            case 35: 
            case 39: {
                return optionFormats.STRING;
            }
            case 1: 
            case 4: {
                return optionFormats.OPAQUE;
            }
        }
        return optionFormats.UNKNOWN;
    }

    public static boolean isCritical(int optionNumber) {
        return (optionNumber & 1) != 0;
    }

    public static boolean isElective(int optionNumber) {
        return (optionNumber & 1) == 0;
    }

    public static boolean isUnsafe(int optionNumber) {
        return (optionNumber & 2) > 0;
    }

    public static boolean isSafe(int optionNumber) {
        return !OptionNumberRegistry.isUnsafe(optionNumber);
    }

    public static boolean isNoCacheKey(int optionNumber) {
        return (optionNumber & 0x1E) == 28;
    }

    public static boolean isCacheKey(int optionNumber) {
        return !OptionNumberRegistry.isNoCacheKey(optionNumber);
    }

    public static boolean isSingleValue(int optionNumber) {
        switch (optionNumber) {
            default: {
                return true;
            }
            case 1: 
            case 4: 
            case 8: 
            case 11: 
            case 15: 
            case 20: 
        }
        return false;
    }

    public static boolean isUriOption(int optionNumber) {
        boolean result = optionNumber == 3 || optionNumber == 11 || optionNumber == 7 || optionNumber == 15;
        return result;
    }

    public static String toString(int optionNumber) {
        switch (optionNumber) {
            case 0: 
            case 128: 
            case 132: 
            case 136: 
            case 140: {
                return "Reserved";
            }
            case 1: {
                return "If-Match";
            }
            case 3: {
                return "Uri-Host";
            }
            case 4: {
                return "ETag";
            }
            case 5: {
                return "If-None-Match";
            }
            case 7: {
                return "Uri-Port";
            }
            case 8: {
                return "Location-Path";
            }
            case 11: {
                return "Uri-Path";
            }
            case 12: {
                return "Content-Format";
            }
            case 14: {
                return "Max-Age";
            }
            case 15: {
                return "Uri-Query";
            }
            case 17: {
                return "Accept";
            }
            case 20: {
                return "Location-Query";
            }
            case 35: {
                return "Proxy-Uri";
            }
            case 39: {
                return "Proxy-Scheme";
            }
            case 6: {
                return "Observe";
            }
            case 23: {
                return "Block2";
            }
            case 27: {
                return "Block1";
            }
            case 28: {
                return "Size2";
            }
            case 60: {
                return "Size1";
            }
        }
        return String.format("Unknown (%d)", optionNumber);
    }

    public static int toNumber(String name) {
        if ("If-Match".equals(name)) {
            return 1;
        }
        if ("Uri-Host".equals(name)) {
            return 3;
        }
        if ("ETag".equals(name)) {
            return 4;
        }
        if ("If-None-Match".equals(name)) {
            return 5;
        }
        if ("Uri-Port".equals(name)) {
            return 7;
        }
        if ("Location-Path".equals(name)) {
            return 8;
        }
        if ("Uri-Path".equals(name)) {
            return 11;
        }
        if ("Content-Format".equals(name)) {
            return 12;
        }
        if ("Max-Age".equals(name)) {
            return 14;
        }
        if ("Uri-Query".equals(name)) {
            return 15;
        }
        if ("Accept".equals(name)) {
            return 17;
        }
        if ("Location-Query".equals(name)) {
            return 20;
        }
        if ("Proxy-Uri".equals(name)) {
            return 35;
        }
        if ("Proxy-Scheme".equals(name)) {
            return 39;
        }
        if ("Observe".equals(name)) {
            return 6;
        }
        if ("Block2".equals(name)) {
            return 23;
        }
        if ("Block1".equals(name)) {
            return 27;
        }
        if ("Size2".equals(name)) {
            return 28;
        }
        if ("Size1".equals(name)) {
            return 60;
        }
        return -1;
    }

    private OptionNumberRegistry() {
    }

    public static class Defaults {
        public static final long MAX_AGE = 60L;
    }

    public static class Names {
        public static final String Reserved = "Reserved";
        public static final String If_Match = "If-Match";
        public static final String Uri_Host = "Uri-Host";
        public static final String ETag = "ETag";
        public static final String If_None_Match = "If-None-Match";
        public static final String Uri_Port = "Uri-Port";
        public static final String Location_Path = "Location-Path";
        public static final String Uri_Path = "Uri-Path";
        public static final String Content_Format = "Content-Format";
        public static final String Max_Age = "Max-Age";
        public static final String Uri_Query = "Uri-Query";
        public static final String Accept = "Accept";
        public static final String Location_Query = "Location-Query";
        public static final String Proxy_Uri = "Proxy-Uri";
        public static final String Proxy_Scheme = "Proxy-Scheme";
        public static final String Size1 = "Size1";
        public static final String Observe = "Observe";
        public static final String Block2 = "Block2";
        public static final String Block1 = "Block1";
        public static final String Size2 = "Size2";
    }

    public static enum optionFormats {
        INTEGER,
        STRING,
        OPAQUE,
        UNKNOWN;

    }
}

