/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;

public final class OptionSet {
    private static final int MAX_OBSERVE_NO = 0xFFFFFF;
    private List<byte[]> if_match_list;
    private String uri_host;
    private List<byte[]> etag_list;
    private boolean if_none_match;
    private Integer uri_port;
    private List<String> location_path_list;
    private List<String> uri_path_list;
    private Integer content_format;
    private Long max_age;
    private List<String> uri_query_list;
    private Integer accept;
    private List<String> location_query_list;
    private String proxy_uri;
    private String proxy_scheme;
    private BlockOption block1;
    private BlockOption block2;
    private Integer size1;
    private Integer size2;
    private Integer observe;
    private List<Option> others;

    public OptionSet() {
        this.if_match_list = null;
        this.uri_host = null;
        this.etag_list = null;
        this.if_none_match = false;
        this.uri_port = null;
        this.location_path_list = null;
        this.uri_path_list = null;
        this.content_format = null;
        this.max_age = null;
        this.uri_query_list = null;
        this.accept = null;
        this.location_query_list = null;
        this.proxy_uri = null;
        this.proxy_scheme = null;
        this.block1 = null;
        this.block2 = null;
        this.size1 = null;
        this.size2 = null;
        this.observe = null;
        this.others = null;
    }

    public void clear() {
        if (this.if_match_list != null) {
            this.if_match_list.clear();
        }
        this.uri_host = null;
        if (this.etag_list != null) {
            this.etag_list.clear();
        }
        this.if_none_match = false;
        this.uri_port = null;
        if (this.location_path_list != null) {
            this.location_path_list.clear();
        }
        if (this.uri_path_list != null) {
            this.uri_path_list.clear();
        }
        this.content_format = null;
        this.max_age = null;
        if (this.uri_query_list != null) {
            this.uri_query_list.clear();
        }
        this.accept = null;
        if (this.location_query_list != null) {
            this.location_path_list.clear();
        }
        this.proxy_uri = null;
        this.proxy_scheme = null;
        this.block1 = null;
        this.block2 = null;
        this.observe = null;
        if (this.others != null) {
            this.others.clear();
        }
    }

    public OptionSet(OptionSet origin) {
        if (origin == null) {
            throw new NullPointerException();
        }
        this.if_match_list = this.copyList(origin.if_match_list);
        this.uri_host = origin.uri_host;
        this.etag_list = this.copyList(origin.etag_list);
        this.if_none_match = origin.if_none_match;
        this.uri_port = origin.uri_port;
        this.location_path_list = this.copyList(origin.location_path_list);
        this.uri_path_list = this.copyList(origin.uri_path_list);
        this.content_format = origin.content_format;
        this.max_age = origin.max_age;
        this.uri_query_list = this.copyList(origin.uri_query_list);
        this.accept = origin.accept;
        this.location_query_list = this.copyList(origin.location_query_list);
        this.proxy_uri = origin.proxy_uri;
        this.proxy_scheme = origin.proxy_scheme;
        if (origin.block1 != null) {
            this.block1 = new BlockOption(origin.block1);
        }
        if (origin.block2 != null) {
            this.block2 = new BlockOption(origin.block2);
        }
        this.observe = origin.observe;
        this.others = this.copyList(origin.others);
    }

    private <T> List<T> copyList(List<T> list) {
        if (list == null) {
            return null;
        }
        return new LinkedList<T>(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getIfMatch() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            if (this.if_match_list == null) {
                this.if_match_list = new LinkedList<byte[]>();
            }
        }
        return this.if_match_list;
    }

    public int getIfMatchCount() {
        return this.getIfMatch().size();
    }

    public boolean isIfMatch(byte[] check) {
        if (this.if_match_list == null) {
            return true;
        }
        for (byte[] etag : this.if_match_list) {
            if (etag.length == 0) {
                return true;
            }
            if (!Arrays.equals(etag, check)) continue;
            return true;
        }
        return false;
    }

    public OptionSet addIfMatch(byte[] etag) {
        if (etag == null) {
            throw new IllegalArgumentException("If-Match option must not be null");
        }
        if (etag.length > 8) {
            throw new IllegalArgumentException("If-Match option must be smaller or equal to 8 bytes: " + Utils.toHexString(etag));
        }
        this.getIfMatch().add(etag);
        return this;
    }

    public OptionSet removeIfMatch(byte[] etag) {
        this.getIfMatch().remove(etag);
        return this;
    }

    public OptionSet clearIfMatchs() {
        this.getIfMatch().clear();
        return this;
    }

    public String getUriHost() {
        return this.uri_host;
    }

    public boolean hasUriHost() {
        return this.uri_host != null;
    }

    public OptionSet setUriHost(String host) {
        if (host == null) {
            throw new NullPointerException("URI-Host must not be null");
        }
        if (host.length() < 1 || 255 < host.length()) {
            throw new IllegalArgumentException("URI-Host option's length must be between 1 and 255 inclusive");
        }
        this.uri_host = host;
        return this;
    }

    public OptionSet removeUriHost() {
        this.uri_host = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getETags() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            if (this.etag_list == null) {
                this.etag_list = new LinkedList<byte[]>();
            }
        }
        return this.etag_list;
    }

    public int getETagCount() {
        return this.getETags().size();
    }

    public boolean containsETag(byte[] check) {
        if (this.etag_list == null) {
            return false;
        }
        for (byte[] etag : this.etag_list) {
            if (!Arrays.equals(etag, check)) continue;
            return true;
        }
        return false;
    }

    public OptionSet addETag(byte[] etag) {
        if (etag == null) {
            throw new IllegalArgumentException("ETag option must not be null");
        }
        this.getETags().add(etag);
        return this;
    }

    public OptionSet removeETag(byte[] etag) {
        this.getETags().remove(etag);
        return this;
    }

    public OptionSet clearETags() {
        this.getETags().clear();
        return this;
    }

    public boolean hasIfNoneMatch() {
        return this.if_none_match;
    }

    public OptionSet setIfNoneMatch(boolean present) {
        this.if_none_match = present;
        return this;
    }

    public Integer getUriPort() {
        return this.uri_port;
    }

    public boolean hasUriPort() {
        return this.uri_port != null;
    }

    public OptionSet setUriPort(int port) {
        if (port < 0 || 65535 < port) {
            throw new IllegalArgumentException("URI port option must be between 0 and 65535 (2 bytes) inclusive but was " + port);
        }
        this.uri_port = port;
        return this;
    }

    public OptionSet removeUriPort() {
        this.uri_port = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLocationPath() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            if (this.location_path_list == null) {
                this.location_path_list = new LinkedList<String>();
            }
        }
        return this.location_path_list;
    }

    public String getLocationString() {
        StringBuilder builder = new StringBuilder();
        builder.append("/");
        builder.append(this.getLocationPathString());
        if (this.getLocationQueryCount() > 0) {
            builder.append("?");
            builder.append(this.getLocationQueryString());
        }
        return builder.toString();
    }

    public String getLocationPathString() {
        StringBuilder builder = new StringBuilder();
        for (String segment : this.getLocationPath()) {
            builder.append(segment).append("/");
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public int getLocationPathCount() {
        return this.getLocationPath().size();
    }

    public OptionSet addLocationPath(String segment) {
        if (segment == null) {
            throw new IllegalArgumentException("Location-Path option must not be null");
        }
        if (segment.getBytes(CoAP.UTF8_CHARSET).length > 255) {
            throw new IllegalArgumentException("Location-Path option must be smaller or euqal to 255 bytes (UTF-8 encoded): " + segment);
        }
        this.getLocationPath().add(segment);
        return this;
    }

    public OptionSet clearLocationPath() {
        this.getLocationPath().clear();
        return this;
    }

    public OptionSet setLocationPath(String path) {
        String slash = "/";
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        this.clearLocationPath();
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.addLocationPath(segment);
            ++n2;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUriPath() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            if (this.uri_path_list == null) {
                this.uri_path_list = new LinkedList<String>();
            }
        }
        return this.uri_path_list;
    }

    public String getUriPathString() {
        StringBuilder buffer = new StringBuilder();
        for (String element : this.getUriPath()) {
            buffer.append(element).append("/");
        }
        if (buffer.length() == 0) {
            return "";
        }
        return buffer.substring(0, buffer.length() - 1);
    }

    public int getURIPathCount() {
        return this.getUriPath().size();
    }

    public OptionSet setUriPath(String path) {
        String slash = "/";
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        this.clearUriPath();
        String[] stringArray = path.split("/");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            this.addUriPath(segment);
            ++n2;
        }
        return this;
    }

    public OptionSet addUriPath(String segment) {
        if (segment == null) {
            throw new IllegalArgumentException("URI path option must not be null");
        }
        if (segment.getBytes(CoAP.UTF8_CHARSET).length > 255) {
            throw new IllegalArgumentException("Uri-Path option must be smaller or euqal to 255 bytes (UTF-8 encoded): " + segment);
        }
        this.getUriPath().add(segment);
        return this;
    }

    public OptionSet clearUriPath() {
        this.getUriPath().clear();
        return this;
    }

    public int getContentFormat() {
        return this.hasContentFormat() ? this.content_format : -1;
    }

    public boolean hasContentFormat() {
        return this.content_format != null;
    }

    public boolean isContentFormat(int format) {
        return this.content_format != null && this.content_format == format;
    }

    public OptionSet setContentFormat(int format) {
        this.content_format = format > -1 ? Integer.valueOf(format) : null;
        return this;
    }

    public OptionSet removeContentFormat() {
        this.content_format = null;
        return this;
    }

    public Long getMaxAge() {
        Long m = this.max_age;
        return m != null ? m : 60L;
    }

    public boolean hasMaxAge() {
        return this.max_age != null;
    }

    public OptionSet setMaxAge(long age) {
        if (age < 0L || 0xFFFFFFFFL < age) {
            throw new IllegalArgumentException("Max-Age option must be between 0 and 4294967295 (4 bytes) inclusive");
        }
        this.max_age = age;
        return this;
    }

    public OptionSet removeMaxAge() {
        this.max_age = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getUriQuery() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            if (this.uri_query_list == null) {
                this.uri_query_list = new LinkedList<String>();
            }
        }
        return this.uri_query_list;
    }

    public int getURIQueryCount() {
        return this.getUriQuery().size();
    }

    public String getUriQueryString() {
        StringBuilder builder = new StringBuilder();
        for (String query : this.getUriQuery()) {
            builder.append(query).append("&");
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public OptionSet setUriQuery(String query) {
        while (query.startsWith("?")) {
            query = query.substring(1);
        }
        this.clearUriQuery();
        String[] stringArray = query.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!segment.isEmpty()) {
                this.addUriQuery(segment);
            }
            ++n2;
        }
        return this;
    }

    public OptionSet addUriQuery(String argument) {
        if (argument == null) {
            throw new NullPointerException("Uri-Query option must not be null");
        }
        if (argument.getBytes(CoAP.UTF8_CHARSET).length > 255) {
            throw new IllegalArgumentException("Uri-Query option must be smaller or euqal to 255 bytes (UTF-8 encoded): " + argument);
        }
        this.getUriQuery().add(argument);
        return this;
    }

    public OptionSet removeUriQuery(String argument) {
        this.getUriQuery().remove(argument);
        return this;
    }

    public OptionSet clearUriQuery() {
        this.getUriQuery().clear();
        return this;
    }

    public int getAccept() {
        return this.hasAccept() ? this.accept : -1;
    }

    public boolean hasAccept() {
        return this.accept != null;
    }

    public boolean isAccept(int format) {
        return this.accept != null && this.accept == format;
    }

    public OptionSet setAccept(int format) {
        if (format < 0 || format > 65535) {
            throw new IllegalArgumentException("Accept option must be between 0 and 65535 (2 bytes) inclusive");
        }
        this.accept = format;
        return this;
    }

    public OptionSet removeAccept() {
        this.accept = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getLocationQuery() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            if (this.location_query_list == null) {
                this.location_query_list = new LinkedList<String>();
            }
        }
        return this.location_query_list;
    }

    public int getLocationQueryCount() {
        return this.getLocationQuery().size();
    }

    public String getLocationQueryString() {
        StringBuilder builder = new StringBuilder();
        for (String query : this.getLocationQuery()) {
            builder.append(query).append("&");
        }
        if (builder.length() > 0) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public OptionSet setLocationQuery(String query) {
        while (query.startsWith("?")) {
            query = query.substring(1);
        }
        this.clearLocationQuery();
        String[] stringArray = query.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!segment.isEmpty()) {
                this.addLocationQuery(segment);
            }
            ++n2;
        }
        return this;
    }

    public OptionSet addLocationQuery(String argument) {
        if (argument == null) {
            throw new NullPointerException("Location-Query option must not be null");
        }
        if (argument.getBytes(CoAP.UTF8_CHARSET).length > 255) {
            throw new IllegalArgumentException("Location-Query option must be smaller or euqal to 255 bytes (UTF-8 encoded): " + argument);
        }
        this.getLocationQuery().add(argument);
        return this;
    }

    public OptionSet removeLocationQuery(String argument) {
        this.getLocationQuery().remove(argument);
        return this;
    }

    public OptionSet clearLocationQuery() {
        this.getLocationQuery().clear();
        return this;
    }

    public String getProxyUri() {
        return this.proxy_uri;
    }

    public boolean hasProxyUri() {
        return this.proxy_uri != null;
    }

    public OptionSet setProxyUri(String uri) {
        if (uri == null) {
            throw new NullPointerException("Proxy-Uri option must not be null");
        }
        if (uri.getBytes(CoAP.UTF8_CHARSET).length < 1 || 1034 < uri.getBytes(CoAP.UTF8_CHARSET).length) {
            throw new IllegalArgumentException("Proxy-Uri option must be between 1 and 1034 bytes inclusive (UTF-8 encoded): " + uri);
        }
        this.proxy_uri = uri;
        return this;
    }

    public OptionSet removeProxyUri() {
        this.proxy_uri = null;
        return this;
    }

    public String getProxyScheme() {
        return this.proxy_scheme;
    }

    public boolean hasProxyScheme() {
        return this.proxy_scheme != null;
    }

    public OptionSet setProxyScheme(String scheme) {
        if (scheme == null) {
            throw new NullPointerException("Proxy-Scheme option must not be null");
        }
        if (scheme.getBytes(CoAP.UTF8_CHARSET).length < 1 || 255 < scheme.getBytes(CoAP.UTF8_CHARSET).length) {
            throw new IllegalArgumentException("Proxy-Scheme option must be between 1 and 255 bytes inclusive (UTF-8 encoded): " + scheme);
        }
        this.proxy_scheme = scheme;
        return this;
    }

    public OptionSet removeProxyScheme() {
        this.proxy_scheme = null;
        return this;
    }

    public BlockOption getBlock1() {
        return this.block1;
    }

    public boolean hasBlock1() {
        return this.block1 != null;
    }

    public OptionSet setBlock1(int szx, boolean m, int num) {
        this.block1 = new BlockOption(szx, m, num);
        return this;
    }

    public OptionSet setBlock1(byte[] value) {
        this.block1 = new BlockOption(value);
        return this;
    }

    public OptionSet setBlock1(BlockOption block) {
        this.block1 = block;
        return this;
    }

    public OptionSet removeBlock1() {
        this.block1 = null;
        return this;
    }

    public BlockOption getBlock2() {
        return this.block2;
    }

    public boolean hasBlock2() {
        return this.block2 != null;
    }

    public OptionSet setBlock2(int szx, boolean m, int num) {
        this.block2 = new BlockOption(szx, m, num);
        return this;
    }

    public OptionSet setBlock2(byte[] value) {
        this.block2 = new BlockOption(value);
        return this;
    }

    public OptionSet setBlock2(BlockOption block) {
        this.block2 = block;
        return this;
    }

    public OptionSet removeBlock2() {
        this.block2 = null;
        return this;
    }

    public Integer getSize1() {
        return this.size1;
    }

    public boolean hasSize1() {
        return this.size1 != null;
    }

    public OptionSet setSize1(int size) {
        this.size1 = size;
        return this;
    }

    public OptionSet removeSize1() {
        this.size1 = null;
        return this;
    }

    public Integer getSize2() {
        return this.size2;
    }

    public boolean hasSize2() {
        return this.size2 != null;
    }

    public OptionSet setSize2(int size) {
        this.size2 = size;
        return this;
    }

    public OptionSet removeSize2() {
        this.size2 = null;
        return this;
    }

    public Integer getObserve() {
        return this.observe;
    }

    public boolean hasObserve() {
        return this.observe != null;
    }

    public OptionSet setObserve(int seqnum) {
        if (!OptionSet.isValidObserveOption(seqnum)) {
            throw new IllegalArgumentException("Observe option must be between 0 and 16777215 (3 bytes) inclusive");
        }
        this.observe = seqnum;
        return this;
    }

    public OptionSet removeObserve() {
        this.observe = null;
        return this;
    }

    public static boolean isValidObserveOption(int value) {
        return value >= 0 && value <= 0xFFFFFF;
    }

    public boolean hasOption(int number) {
        return Collections.binarySearch(this.asSortedList(), new Option(number)) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Option> getOthers() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            if (this.others == null) {
                this.others = new LinkedList<Option>();
            }
        }
        return this.others;
    }

    public List<Option> asSortedList() {
        ArrayList<Option> options = new ArrayList<Option>();
        if (this.if_match_list != null) {
            for (byte[] value : this.if_match_list) {
                options.add(new Option(1, value));
            }
        }
        if (this.hasUriHost()) {
            options.add(new Option(3, this.getUriHost()));
        }
        if (this.etag_list != null) {
            for (byte[] value : this.etag_list) {
                options.add(new Option(4, value));
            }
        }
        if (this.hasIfNoneMatch()) {
            options.add(new Option(5));
        }
        if (this.hasUriPort()) {
            options.add(new Option(7, this.getUriPort()));
        }
        if (this.location_path_list != null) {
            for (String str : this.location_path_list) {
                options.add(new Option(8, str));
            }
        }
        if (this.uri_path_list != null) {
            for (String str : this.uri_path_list) {
                options.add(new Option(11, str));
            }
        }
        if (this.hasContentFormat()) {
            options.add(new Option(12, this.getContentFormat()));
        }
        if (this.hasMaxAge()) {
            options.add(new Option(14, this.getMaxAge()));
        }
        if (this.uri_query_list != null) {
            for (String str : this.uri_query_list) {
                options.add(new Option(15, str));
            }
        }
        if (this.hasAccept()) {
            options.add(new Option(17, this.getAccept()));
        }
        if (this.location_query_list != null) {
            for (String str : this.location_query_list) {
                options.add(new Option(20, str));
            }
        }
        if (this.hasProxyUri()) {
            options.add(new Option(35, this.getProxyUri()));
        }
        if (this.hasProxyScheme()) {
            options.add(new Option(39, this.getProxyScheme()));
        }
        if (this.hasObserve()) {
            options.add(new Option(6, this.getObserve()));
        }
        if (this.hasBlock1()) {
            options.add(new Option(27, this.getBlock1().getValue()));
        }
        if (this.hasBlock2()) {
            options.add(new Option(23, this.getBlock2().getValue()));
        }
        if (this.hasSize1()) {
            options.add(new Option(60, this.getSize1()));
        }
        if (this.hasSize2()) {
            options.add(new Option(28, this.getSize2()));
        }
        if (this.others != null) {
            options.addAll(this.others);
        }
        Collections.sort(options);
        return options;
    }

    public OptionSet addOption(Option option) {
        switch (option.getNumber()) {
            case 1: {
                this.addIfMatch(option.getValue());
                break;
            }
            case 3: {
                this.setUriHost(option.getStringValue());
                break;
            }
            case 4: {
                this.addETag(option.getValue());
                break;
            }
            case 5: {
                this.setIfNoneMatch(true);
                break;
            }
            case 7: {
                this.setUriPort(option.getIntegerValue());
                break;
            }
            case 8: {
                this.addLocationPath(option.getStringValue());
                break;
            }
            case 11: {
                this.addUriPath(option.getStringValue());
                break;
            }
            case 12: {
                this.setContentFormat(option.getIntegerValue());
                break;
            }
            case 14: {
                this.setMaxAge(option.getLongValue());
                break;
            }
            case 15: {
                this.addUriQuery(option.getStringValue());
                break;
            }
            case 17: {
                this.setAccept(option.getIntegerValue());
                break;
            }
            case 20: {
                this.addLocationQuery(option.getStringValue());
                break;
            }
            case 35: {
                this.setProxyUri(option.getStringValue());
                break;
            }
            case 39: {
                this.setProxyScheme(option.getStringValue());
                break;
            }
            case 27: {
                this.setBlock1(option.getValue());
                break;
            }
            case 23: {
                this.setBlock2(option.getValue());
                break;
            }
            case 60: {
                this.setSize1(option.getIntegerValue());
                break;
            }
            case 28: {
                this.setSize2(option.getIntegerValue());
                break;
            }
            case 6: {
                this.setObserve(option.getIntegerValue());
                break;
            }
            default: {
                this.getOthers().add(option);
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbv = new StringBuilder();
        int oldNr = -1;
        boolean list = false;
        sb.append('{');
        for (Option opt : this.asSortedList()) {
            if (opt.getNumber() != oldNr) {
                if (oldNr != -1) {
                    if (list) {
                        sbv.append(']');
                    }
                    sb.append(sbv.toString());
                    sbv = new StringBuilder();
                    sb.append(", ");
                }
                list = false;
                sb.append('\"');
                sb.append(OptionNumberRegistry.toString(opt.getNumber()));
                sb.append('\"');
                sb.append(':');
            } else {
                if (!list) {
                    sbv.insert(0, '[');
                }
                list = true;
                sbv.append(",");
            }
            sbv.append(opt.toValueString());
            oldNr = opt.getNumber();
        }
        if (list) {
            sbv.append(']');
        }
        sb.append(sbv.toString());
        sb.append('}');
        return sb.toString();
    }
}

