/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.network.MessageIdProvider;
import org.eclipse.californium.core.network.MessageIdTracker;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;

public class InMemoryMessageIdProvider
implements MessageIdProvider {
    private final LeastRecentlyUsedCache<InetSocketAddress, MessageIdTracker> trackers;
    private final NetworkConfig config;

    public InMemoryMessageIdProvider(NetworkConfig config) {
        if (config == null) {
            throw new NullPointerException("Config must not be null");
        }
        this.config = config;
        this.trackers = new LeastRecentlyUsedCache(config.getInt("MAX_ACTIVE_PEERS", 500000), config.getLong("MAX_PEER_INACTIVITY_PERIOD", 129600L));
    }

    @Override
    public synchronized int getNextMessageId(InetSocketAddress destination) {
        MessageIdTracker tracker = this.trackers.get(destination);
        if (tracker == null && !this.trackers.put(destination, tracker = new MessageIdTracker(this.config))) {
            return -1;
        }
        return tracker.getNextMessageId();
    }
}

