/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.BaseMatcher;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.ExchangeObserver;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.elements.CorrelationContext;

public final class UdpMatcher
extends BaseMatcher {
    private static final Logger LOGGER = Logger.getLogger(UdpMatcher.class.getName());
    private final ExchangeObserver exchangeObserver = new ExchangeObserverImpl();
    private final boolean useStrictResponseMatching;

    public UdpMatcher(NetworkConfig config) {
        super(config);
        this.useStrictResponseMatching = config.getBoolean("USE_STRICT_RESPONSE_MATCHING");
        if (LOGGER.isLoggable(Level.CONFIG)) {
            String msg = "UdpMatcher uses " + "USE_STRICT_RESPONSE_MATCHING" + "=" + this.useStrictResponseMatching;
            LOGGER.config(msg);
        }
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        exchange.setObserver(this.exchangeObserver);
        this.exchangeStore.registerOutboundRequest(exchange);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "Tracking open request [MID: {0}, Token: {1}]", new Object[]{request.getMID(), request.getTokenString()});
        }
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        ObserveRelation relation;
        response.setToken(exchange.getCurrentRequest().getToken());
        if ((response.getType() == CoAP.Type.CON || response.getType() == CoAP.Type.ACK) && (relation = exchange.getRelation()) != null) {
            this.removeNotificationsOf(relation);
        }
        if (response.getOptions().hasBlock2()) {
            Request request = exchange.getCurrentRequest();
            Exchange.KeyUri idByUri = new Exchange.KeyUri(request.getURI(), response.getDestination().getAddress(), response.getDestinationPort());
            if (exchange.getResponseBlockStatus() != null && !response.getOptions().hasObserve()) {
                if (this.exchangeStore.registerBlockwiseExchange(idByUri, exchange) == null) {
                    LOGGER.log(Level.FINE, "Ongoing Block2 started late, storing {0} for {1}", new Object[]{idByUri, request});
                } else {
                    LOGGER.log(Level.FINE, "Ongoing Block2 continued, storing {0} for {1}", new Object[]{idByUri, request});
                }
            } else {
                LOGGER.log(Level.FINE, "Ongoing Block2 completed, cleaning up {0} for {1}", new Object[]{idByUri, request});
                this.exchangeStore.remove(idByUri);
            }
        }
        if (response.getType() == CoAP.Type.CON) {
            this.exchangeStore.registerOutboundResponse(exchange);
        } else if (response.getType() == CoAP.Type.NON) {
            if (response.getOptions().hasObserve()) {
                this.exchangeStore.registerOutboundResponse(exchange);
            } else {
                this.exchangeStore.assignMessageId(response);
            }
        }
        if (response.getType() != CoAP.Type.CON && response.isLast()) {
            exchange.setComplete();
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        message.setToken(new byte[0]);
        if (message.getType() == CoAP.Type.RST && exchange != null) {
            exchange.setComplete();
        }
    }

    @Override
    public Exchange receiveRequest(Request request) {
        Exchange.KeyMID idByMID = Exchange.KeyMID.fromInboundMessage(request);
        if (!request.getOptions().hasBlock1() && !request.getOptions().hasBlock2()) {
            Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE);
            Exchange previous = this.exchangeStore.findPrevious(idByMID, exchange);
            if (previous == null) {
                exchange.setObserver(this.exchangeObserver);
                return exchange;
            }
            LOGGER.log(Level.FINER, "Duplicate request: {0}", request);
            request.setDuplicate(true);
            return previous;
        }
        Exchange.KeyUri idByUri = new Exchange.KeyUri(request.getURI(), request.getSource().getAddress(), request.getSourcePort());
        LOGGER.log(Level.FINE, "Looking up ongoing exchange for {0}", idByUri);
        Exchange ongoing = this.exchangeStore.get(idByUri);
        if (ongoing != null) {
            Exchange prev = this.exchangeStore.findPrevious(idByMID, ongoing);
            if (prev != null) {
                LOGGER.log(Level.FINER, "Duplicate ongoing request: {0}", request);
                request.setDuplicate(true);
            } else if (ongoing.getCurrentResponse() != null && ongoing.getCurrentResponse().getType() != CoAP.Type.ACK && !ongoing.getCurrentResponse().getOptions().hasObserve()) {
                idByMID = Exchange.KeyMID.fromOutboundMessage(ongoing.getCurrentResponse());
                LOGGER.log(Level.FINE, "Ongoing exchange got new request, cleaning up {0}", idByMID);
                this.exchangeStore.remove(idByMID);
            }
            return ongoing;
        }
        Exchange exchange = new Exchange(request, Exchange.Origin.REMOTE);
        Exchange previous = this.exchangeStore.findPrevious(idByMID, exchange);
        if (previous == null) {
            LOGGER.log(Level.FINER, "New ongoing request, storing {0} for {1}", new Object[]{idByUri, request});
            exchange.setObserver(this.exchangeObserver);
            this.exchangeStore.registerBlockwiseExchange(idByUri, exchange);
            return exchange;
        }
        LOGGER.log(Level.FINER, "Duplicate initial request: {0}", request);
        request.setDuplicate(true);
        return previous;
    }

    @Override
    public Exchange receiveResponse(Response response, CorrelationContext responseContext) {
        Exchange.KeyMID idByMID = Exchange.KeyMID.fromInboundMessage(response);
        Exchange.KeyToken idByToken = Exchange.KeyToken.fromInboundMessage(response);
        LOGGER.log(Level.FINER, "received response {0}", response);
        Exchange exchange = this.exchangeStore.get(idByToken);
        if (exchange == null) {
            if (response.getType() != CoAP.Type.ACK) {
                Exchange prev = this.exchangeStore.find(idByMID);
                if (prev != null) {
                    LOGGER.log(Level.FINER, "Received response for already completed exchange: {0}", response);
                    response.setDuplicate(true);
                    return prev;
                }
            } else {
                LOGGER.log(Level.FINER, "Discarding unmatchable piggy-backed response from [{0}:{1}]: {2}", new Object[]{response.getSource(), response.getSourcePort(), response});
            }
            return null;
        }
        if (this.isResponseRelatedToRequest(exchange, responseContext)) {
            if ((response.getType() == CoAP.Type.CON || response.getType() == CoAP.Type.NON) && this.exchangeStore.findPrevious(idByMID, exchange) != null) {
                LOGGER.log(Level.FINER, "Received duplicate response for open exchange: {0}", response);
                response.setDuplicate(true);
            } else {
                idByMID = Exchange.KeyMID.fromOutboundMessage(exchange.getCurrentRequest());
                if (this.exchangeStore.remove(idByMID) != null) {
                    LOGGER.log(Level.FINE, "Closed open request [{0}]", idByMID);
                }
            }
            if (response.getType() == CoAP.Type.ACK && exchange.getCurrentRequest().getMID() != response.getMID()) {
                LOGGER.log(Level.WARNING, "Possible MID reuse before lifetime end for token [{0}], expected MID {1} but received {2}", new Object[]{response.getTokenString(), exchange.getCurrentRequest().getMID(), response.getMID()});
            }
            return exchange;
        }
        LOGGER.log(Level.INFO, "Ignoring potentially forged response for token {0} with non-matching correlation context", idByToken);
        return null;
    }

    private boolean isResponseRelatedToRequest(Exchange exchange, CorrelationContext responseContext) {
        if (exchange.getCorrelationContext() == null) {
            return true;
        }
        if (exchange.getCorrelationContext().get("DTLS_SESSION_ID") != null) {
            if (this.useStrictResponseMatching) {
                return this.isResponseStrictlyRelatedToDtlsRequest(exchange.getCorrelationContext(), responseContext);
            }
            return this.isResponseRelatedToDtlsRequest(exchange.getCorrelationContext(), responseContext);
        }
        return exchange.getCorrelationContext().equals(responseContext);
    }

    private boolean isResponseRelatedToDtlsRequest(CorrelationContext requestContext, CorrelationContext responseContext) {
        if (responseContext == null) {
            return false;
        }
        return requestContext.get("DTLS_SESSION_ID").equals(responseContext.get("DTLS_SESSION_ID")) && requestContext.get("DTLS_CIPHER").equals(responseContext.get("DTLS_CIPHER"));
    }

    private boolean isResponseStrictlyRelatedToDtlsRequest(CorrelationContext requestContext, CorrelationContext responseContext) {
        if (responseContext == null) {
            return false;
        }
        return requestContext.get("DTLS_SESSION_ID").equals(responseContext.get("DTLS_SESSION_ID")) && requestContext.get("DTLS_EPOCH").equals(responseContext.get("DTLS_EPOCH")) && requestContext.get("DTLS_CIPHER").equals(responseContext.get("DTLS_CIPHER"));
    }

    @Override
    public Exchange receiveEmptyMessage(EmptyMessage message) {
        Exchange.KeyMID idByMID = Exchange.KeyMID.fromInboundMessage(message);
        Exchange exchange = this.exchangeStore.remove(idByMID);
        if (exchange != null) {
            LOGGER.log(Level.FINE, "Received expected reply for message exchange {0}", idByMID);
        } else {
            LOGGER.log(Level.FINER, "Ignoring non-matchable empty message from {0}:{1}: {2}", new Object[]{message.getSource(), message.getSourcePort(), message});
        }
        return exchange;
    }

    private void removeNotificationsOf(ObserveRelation relation) {
        LOGGER.log(Level.FINE, "Removing all remaining NON-notifications of observe relation with {0}", relation.getSource());
        Iterator<Response> iterator = relation.getNotificationIterator();
        while (iterator.hasNext()) {
            Response previous = iterator.next();
            Exchange.KeyMID idByMID = Exchange.KeyMID.fromOutboundMessage(previous);
            this.exchangeStore.remove(idByMID);
            iterator.remove();
        }
    }

    private class ExchangeObserverImpl
    implements ExchangeObserver {
        private ExchangeObserverImpl() {
        }

        @Override
        public void completed(Exchange exchange) {
            if (exchange.getOrigin() == Exchange.Origin.LOCAL) {
                Exchange.KeyMID idByMID = Exchange.KeyMID.fromOutboundMessage(exchange.getCurrentRequest());
                Exchange.KeyToken idByToken = Exchange.KeyToken.fromOutboundMessage(exchange.getCurrentRequest());
                UdpMatcher.this.exchangeStore.remove(idByToken);
                UdpMatcher.this.exchangeStore.remove(idByMID);
                if (!exchange.getCurrentRequest().getOptions().hasObserve()) {
                    UdpMatcher.this.exchangeStore.releaseToken(idByToken);
                }
                LOGGER.log(Level.FINER, "Exchange [{0}, {1}] completed", new Object[]{idByToken, exchange.getOrigin()});
            } else {
                ObserveRelation relation;
                Response response = exchange.getCurrentResponse();
                Request request = exchange.getCurrentRequest();
                if (response != null && response.getType() != CoAP.Type.ACK) {
                    Exchange.KeyMID midKey = Exchange.KeyMID.fromOutboundMessage(response);
                    UdpMatcher.this.exchangeStore.remove(midKey);
                    LOGGER.log(Level.FINER, "Exchange [{0}, {1}] completed", new Object[]{midKey, exchange.getOrigin()});
                }
                if (request != null && (request.getOptions().hasBlock1() || response.getOptions().hasBlock2())) {
                    Exchange.KeyUri uriKey = new Exchange.KeyUri(request.getURI(), request.getSource().getAddress(), request.getSourcePort());
                    LOGGER.log(Level.FINE, "Blockwise exchange with remote peer {0} completed, cleaning up ", uriKey);
                    UdpMatcher.this.exchangeStore.remove(uriKey);
                }
                if ((relation = exchange.getRelation()) != null) {
                    UdpMatcher.this.removeNotificationsOf(relation);
                }
            }
        }

        @Override
        public void contextEstablished(Exchange exchange) {
            Exchange.KeyToken token = Exchange.KeyToken.fromOutboundMessage(exchange.getCurrentRequest());
            UdpMatcher.this.exchangeStore.setContext(token, exchange.getCorrelationContext());
        }
    }
}

