/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.deduplication;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.core.network.deduplication.Deduplicator;

public final class SweepDeduplicator
implements Deduplicator {
    private static final Logger LOGGER = Logger.getLogger(SweepDeduplicator.class.getName());
    private final ConcurrentMap<Exchange.KeyMID, Exchange> incomingMessages = new ConcurrentHashMap<Exchange.KeyMID, Exchange>();
    private boolean running = false;
    private ScheduledExecutorService scheduler;
    private SweepAlgorithm algorithm;

    public SweepDeduplicator(NetworkConfig config) {
        this.algorithm = new SweepAlgorithm(config);
    }

    @Override
    public synchronized void start() {
        if (!this.running) {
            if (this.scheduler == null || this.scheduler.isShutdown()) {
                this.scheduler = Executors.newSingleThreadScheduledExecutor(new Utils.DaemonThreadFactory("Deduplicator"));
            }
            this.algorithm.schedule();
            this.running = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (this.running) {
            this.algorithm.cancel();
            this.scheduler.shutdown();
            this.clear();
            this.running = false;
        }
    }

    @Override
    public Exchange findPrevious(Exchange.KeyMID key, Exchange exchange) {
        return this.incomingMessages.putIfAbsent(key, exchange);
    }

    @Override
    public Exchange find(Exchange.KeyMID key) {
        return (Exchange)this.incomingMessages.get(key);
    }

    @Override
    public void clear() {
        this.incomingMessages.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.incomingMessages.isEmpty();
    }

    private class SweepAlgorithm
    implements Runnable {
        private final long sweepInterval;
        private final long exchangeLifetime;
        private ScheduledFuture<?> future;

        public SweepAlgorithm(NetworkConfig config) {
            this.exchangeLifetime = config.getLong("EXCHANGE_LIFETIME");
            this.sweepInterval = config.getLong("MARK_AND_SWEEP_INTERVAL");
        }

        @Override
        public void run() {
            try {
                try {
                    LOGGER.log(Level.FINEST, "Start Mark-And-Sweep with {0} entries", SweepDeduplicator.this.incomingMessages.size());
                    this.sweep();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Exception in Mark-and-Sweep algorithm", t);
                    try {
                        this.schedule();
                    }
                    catch (Throwable t2) {
                        LOGGER.log(Level.WARNING, "Exception while scheduling Mark-and-Sweep algorithm", t2);
                    }
                }
            }
            finally {
                try {
                    this.schedule();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.WARNING, "Exception while scheduling Mark-and-Sweep algorithm", t);
                }
            }
        }

        private void sweep() {
            long oldestAllowed = System.currentTimeMillis() - this.exchangeLifetime;
            long start = System.currentTimeMillis();
            for (Map.Entry entry : SweepDeduplicator.this.incomingMessages.entrySet()) {
                Exchange exchange = (Exchange)entry.getValue();
                if (exchange.getTimestamp() >= oldestAllowed) continue;
                LOGGER.log(Level.FINER, "Mark-And-Sweep removes {0}", entry.getKey());
                SweepDeduplicator.this.incomingMessages.remove(entry.getKey());
            }
            LOGGER.log(Level.FINE, "Sweep run took {0}ms", System.currentTimeMillis() - start);
        }

        private void schedule() {
            if (!SweepDeduplicator.this.scheduler.isShutdown()) {
                this.future = SweepDeduplicator.this.scheduler.schedule(this, this.sweepInterval, TimeUnit.MILLISECONDS);
            }
        }

        private void cancel() {
            if (this.future != null) {
                this.future.cancel(false);
            }
        }
    }
}

