/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.interceptors;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;

public class MessageTracer
implements MessageInterceptor {
    private static final Logger LOGGER = Logger.getLogger(MessageTracer.class.getCanonicalName());

    @Override
    public void sendRequest(Request request) {
        LOGGER.log(Level.INFO, "{0}:{1} <== req {2}", new Object[]{request.getDestination(), request.getDestinationPort(), request});
    }

    @Override
    public void sendResponse(Response response) {
        LOGGER.log(Level.INFO, "{0}:{1} <== res {2}", new Object[]{response.getDestination(), response.getDestinationPort(), response});
    }

    @Override
    public void sendEmptyMessage(EmptyMessage message) {
        LOGGER.log(Level.INFO, "{0}:{1} <== emp {2}", new Object[]{message.getDestination(), message.getDestinationPort(), message});
    }

    @Override
    public void receiveRequest(Request request) {
        LOGGER.log(Level.INFO, "{0}:{1} ==> req {2}", new Object[]{request.getSource(), request.getSourcePort(), request});
    }

    @Override
    public void receiveResponse(Response response) {
        LOGGER.log(Level.INFO, "{0}:{1} ==> res {2}", new Object[]{response.getSource(), response.getSourcePort(), response});
    }

    @Override
    public void receiveEmptyMessage(EmptyMessage message) {
        LOGGER.log(Level.INFO, "{0}:{1} ==> emp {2}", new Object[]{message.getSource(), message.getSourcePort(), message});
    }
}

