/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.AbstractLayer;

public class TcpAdaptionLayer
extends AbstractLayer {
    private static final Logger LOGGER = Logger.getLogger(TcpAdaptionLayer.class.getName());

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        if (message.isConfirmable()) {
            this.lower().sendEmptyMessage(exchange, message);
        } else {
            LOGGER.log(Level.WARNING, "Attempting to send empty message (ACK/RST) in TCP mode {0}", message);
        }
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        request.setAcknowledged(true);
        this.upper().receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        response.setAcknowledged(true);
        this.upper().receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        LOGGER.log(Level.INFO, "Received empty message in TCP mode {0}", message);
    }
}

