/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.Layer;

public abstract class AbstractLayer
implements Layer {
    private static final Logger LOGGER = Logger.getLogger(AbstractLayer.class.getCanonicalName());
    private Layer upperLayer = LogOnlyLayer.getInstance();
    private Layer lowerLayer = LogOnlyLayer.getInstance();
    protected ScheduledExecutorService executor;

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        this.lowerLayer.sendRequest(exchange, request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        this.lowerLayer.sendResponse(exchange, response);
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.lowerLayer.sendEmptyMessage(exchange, message);
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        this.upperLayer.receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        this.upperLayer.receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.upperLayer.receiveEmptyMessage(exchange, message);
    }

    @Override
    public final void setLowerLayer(Layer layer) {
        if (this.lowerLayer != layer) {
            if (this.lowerLayer != null) {
                this.lowerLayer.setUpperLayer(null);
            }
            this.lowerLayer = layer;
            this.lowerLayer.setUpperLayer(this);
        }
    }

    final Layer lower() {
        return this.lowerLayer;
    }

    @Override
    public final void setUpperLayer(Layer layer) {
        if (this.upperLayer != layer) {
            if (this.upperLayer != null) {
                this.upperLayer.setLowerLayer(null);
            }
            this.upperLayer = layer;
            this.upperLayer.setLowerLayer(this);
        }
    }

    final Layer upper() {
        return this.upperLayer;
    }

    @Override
    public final void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public final void reject(Exchange exchange, Message message) {
        if (message.getType() == CoAP.Type.ACK || message.getType() == CoAP.Type.RST) {
            throw new IllegalArgumentException("Can only reject CON/NON messages");
        }
        this.lower().sendEmptyMessage(exchange, EmptyMessage.newRST(message));
    }

    @Override
    public void destroy() {
    }

    public static final class LogOnlyLayer
    implements Layer {
        private static final LogOnlyLayer INSTANCE = new LogOnlyLayer();

        public static LogOnlyLayer getInstance() {
            return INSTANCE;
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            LOGGER.log(Level.SEVERE, "No lower layer set for sending request [{0}]", request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            LOGGER.log(Level.SEVERE, "No lower layer set for sending response [{0}]", response);
        }

        @Override
        public void sendEmptyMessage(Exchange exchange, EmptyMessage emptyMessage) {
            LOGGER.log(Level.SEVERE, "No lower layer set for sending empty message [{0}]", emptyMessage);
        }

        @Override
        public void receiveRequest(Exchange exchange, Request request) {
            LOGGER.log(Level.SEVERE, "No upper layer set for receiving request [{0}]", request);
        }

        @Override
        public void receiveResponse(Exchange exchange, Response response) {
            LOGGER.log(Level.SEVERE, "No lower layer set for receiving response [{0}]", response);
        }

        @Override
        public void receiveEmptyMessage(Exchange exchange, EmptyMessage emptyMessage) {
            LOGGER.log(Level.SEVERE, "No lower layer set for receiving empty message [{0}]", emptyMessage);
        }

        @Override
        public void setLowerLayer(Layer layer) {
        }

        @Override
        public void setUpperLayer(Layer layer) {
        }

        @Override
        public void setExecutor(ScheduledExecutorService executor) {
        }

        @Override
        public void destroy() {
        }
    }
}

