/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server.resources;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.Resource;

public class ConcurrentCoapResource
extends CoapResource {
    public static int SINGLE_THREADED = 1;
    private int threads;
    private ExecutorService executor;

    public ConcurrentCoapResource(String name) {
        super(name);
        this.threads = this.getAvailableProcessors();
        this.setExecutor(Executors.newFixedThreadPool(this.threads, new Utils.NamedThreadFactory("ConcurrentCoapResource-" + name + '#')));
    }

    public ConcurrentCoapResource(String name, int threads) {
        super(name);
        this.threads = threads;
        this.setExecutor(Executors.newFixedThreadPool(threads, new Utils.NamedThreadFactory("ConcurrentCoapResource-" + name + '#')));
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public ExecutorService getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        return super.getExecutor();
    }

    protected int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int getThreadCount() {
        return this.threads;
    }

    public static ConcurrentCoapResource createConcurrentCoapResource(int threads, final Resource impl) {
        return new ConcurrentCoapResource(impl.getName(), threads){

            @Override
            public void handleRequest(Exchange exchange) {
                impl.handleRequest(exchange);
            }
        };
    }
}

