/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.Arrays;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.ExchangeObserver;
import org.eclipse.californium.core.network.stack.BlockwiseStatus;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.elements.CorrelationContext;

public class Exchange {
    private Endpoint endpoint;
    private ExchangeObserver observer;
    private boolean complete = false;
    private final long timestamp;
    private Request request;
    private Request currentRequest;
    private BlockwiseStatus requestBlockStatus;
    private Response response;
    private Response currentResponse;
    private BlockwiseStatus responseBlockStatus;
    private final Origin origin;
    private boolean timedOut;
    private int currentTimeout;
    private int failedTransmissionCount = 0;
    private ScheduledFuture<?> retransmissionHandle = null;
    private ScheduledFuture<?> blockCleanupHandle = null;
    private BlockOption block1ToAck;
    private ObserveRelation relation;
    private boolean customExecutor = false;
    private CorrelationContext correlationContext;

    public Exchange(Request request, Origin origin) {
        this.currentRequest = request;
        this.origin = origin;
        this.timestamp = System.currentTimeMillis();
    }

    public void sendAccept() {
        assert (this.origin == Origin.REMOTE);
        if (this.request.getType() == CoAP.Type.CON && !this.request.isAcknowledged()) {
            this.request.setAcknowledged(true);
            EmptyMessage ack = EmptyMessage.newACK(this.request);
            this.endpoint.sendEmptyMessage(this, ack);
        }
    }

    public void sendReject() {
        assert (this.origin == Origin.REMOTE);
        this.request.setRejected(true);
        EmptyMessage rst = EmptyMessage.newRST(this.request);
        this.endpoint.sendEmptyMessage(this, rst);
    }

    public void sendResponse(Response response) {
        response.setDestination(this.request.getSource());
        response.setDestinationPort(this.request.getSourcePort());
        this.setResponse(response);
        this.endpoint.sendResponse(this, response);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public boolean isOfLocalOrigin() {
        return this.origin == Origin.LOCAL;
    }

    public Request getRequest() {
        return this.request;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public Request getCurrentRequest() {
        return this.currentRequest;
    }

    public void setCurrentRequest(Request currentRequest) {
        this.currentRequest = currentRequest;
    }

    public BlockwiseStatus getRequestBlockStatus() {
        return this.requestBlockStatus;
    }

    public void setRequestBlockStatus(BlockwiseStatus requestBlockStatus) {
        this.requestBlockStatus = requestBlockStatus;
    }

    public Response getResponse() {
        return this.response;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public Response getCurrentResponse() {
        return this.currentResponse;
    }

    public void setCurrentResponse(Response currentResponse) {
        this.currentResponse = currentResponse;
    }

    public BlockwiseStatus getResponseBlockStatus() {
        return this.responseBlockStatus;
    }

    public void setResponseBlockStatus(BlockwiseStatus responseBlockStatus) {
        this.responseBlockStatus = responseBlockStatus;
    }

    public BlockOption getBlock1ToAck() {
        return this.block1ToAck;
    }

    public void setBlock1ToAck(BlockOption block1ToAck) {
        this.block1ToAck = block1ToAck;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public void setTimedOut() {
        this.timedOut = true;
        this.setComplete();
    }

    public int getFailedTransmissionCount() {
        return this.failedTransmissionCount;
    }

    public void setFailedTransmissionCount(int failedTransmissionCount) {
        this.failedTransmissionCount = failedTransmissionCount;
    }

    public int getCurrentTimeout() {
        return this.currentTimeout;
    }

    public void setCurrentTimeout(int currentTimeout) {
        this.currentTimeout = currentTimeout;
    }

    public synchronized ScheduledFuture<?> getRetransmissionHandle() {
        return this.retransmissionHandle;
    }

    public synchronized void setRetransmissionHandle(ScheduledFuture<?> retransmissionHandle) {
        if (this.retransmissionHandle != null) {
            this.retransmissionHandle.cancel(false);
        }
        this.retransmissionHandle = retransmissionHandle;
    }

    public synchronized ScheduledFuture<?> getBlockCleanupHandle() {
        return this.blockCleanupHandle;
    }

    public synchronized void setBlockCleanupHandle(ScheduledFuture<?> blockCleanupHandle) {
        if (this.blockCleanupHandle != null) {
            this.blockCleanupHandle.cancel(false);
        }
        this.blockCleanupHandle = blockCleanupHandle;
    }

    public void setObserver(ExchangeObserver observer) {
        this.observer = observer;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public void setComplete() {
        this.complete = true;
        ExchangeObserver obs = this.observer;
        if (obs != null) {
            obs.completed(this);
        }
    }

    public void completeCurrentRequest() {
        ExchangeObserver obs = this.observer;
        if (obs != null) {
            obs.completed(this);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ObserveRelation getRelation() {
        return this.relation;
    }

    public void setRelation(ObserveRelation relation) {
        this.relation = relation;
    }

    public boolean hasCustomExecutor() {
        return this.customExecutor;
    }

    public void setCustomExecutor() {
        this.customExecutor = true;
    }

    public void setCorrelationContext(CorrelationContext ctx) {
        this.correlationContext = ctx;
        if (this.observer != null) {
            this.observer.contextEstablished(this);
        }
    }

    public CorrelationContext getCorrelationContext() {
        return this.correlationContext;
    }

    public static final class KeyMID {
        private static final int MAX_PORT_NO = 65535;
        private final int MID;
        private final byte[] address;
        private final int port;
        private final int hash;

        private KeyMID(int mid, byte[] address, int port) {
            if (mid < 0 || mid > 65536) {
                throw new IllegalArgumentException("MID must not be a 16 bit unsigned int");
            }
            if (address == null) {
                throw new NullPointerException("address must not be null");
            }
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Port must be a 16 bit unsigned int");
            }
            this.MID = mid;
            this.address = address;
            this.port = port;
            this.hash = this.createHashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        private int createHashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.MID;
            result = 31 * result + Arrays.hashCode(this.address);
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyMID other = (KeyMID)obj;
            if (this.MID != other.MID) {
                return false;
            }
            if (!Arrays.equals(this.address, other.address)) {
                return false;
            }
            return this.port == other.port;
        }

        public String toString() {
            return "KeyMID[" + this.MID + ", " + Utils.toHexString(this.address) + ":" + this.port + "]";
        }

        public static KeyMID fromInboundMessage(Message message) {
            return new KeyMID(message.getMID(), message.getSource().getAddress(), message.getSourcePort());
        }

        public static KeyMID fromOutboundMessage(Message message) {
            return new KeyMID(message.getMID(), message.getDestination().getAddress(), message.getDestinationPort());
        }
    }

    public static final class KeyToken {
        private static final int MAX_PORT_NO = 65535;
        private final byte[] token;
        private final byte[] address;
        private final int port;
        private final int hash;

        private KeyToken(byte[] token, byte[] address, int port) {
            if (token == null) {
                throw new NullPointerException("token bytes must not be null");
            }
            if (address == null) {
                throw new NullPointerException("address must not be null");
            }
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("port must be a 16 bit unsigned int");
            }
            this.token = Arrays.copyOf(token, token.length);
            this.address = address;
            this.port = port;
            this.hash = this.createHash();
        }

        public static KeyToken fromInboundMessage(Message msg) {
            return new KeyToken(msg.getToken(), msg.getSource().getAddress(), msg.getSourcePort());
        }

        public static KeyToken fromOutboundMessage(Message msg) {
            return new KeyToken(msg.getToken(), msg.getDestination().getAddress(), msg.getDestinationPort());
        }

        public static KeyToken fromValues(byte[] token, byte[] address, int port) {
            return new KeyToken(token, address, port);
        }

        private int createHash() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.port;
            result = 31 * result + Arrays.hashCode(this.address);
            result = 31 * result + Arrays.hashCode(this.token);
            return result;
        }

        public String toString() {
            return "KeyToken[" + Utils.toHexString(this.token) + ", " + Utils.toHexString(this.address) + ":" + this.port + "]";
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            KeyToken other = (KeyToken)obj;
            if (!Arrays.equals(this.address, other.address)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return Arrays.equals(this.token, other.token);
        }

        public byte[] getToken() {
            return Arrays.copyOf(this.token, this.token.length);
        }
    }

    public static final class KeyUri {
        private static final int MAX_PORT_NO = 65535;
        private final String uri;
        private final byte[] address;
        private final int port;
        private final int hash;

        public KeyUri(String uri, byte[] address, int port) {
            if (uri == null) {
                throw new NullPointerException("URI must not be null");
            }
            if (address == null) {
                throw new NullPointerException("address must not be null");
            }
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("port must be an unsigned 16 bit int");
            }
            this.uri = uri;
            this.address = address;
            this.port = port;
            this.hash = (port * 31 + uri.hashCode()) * 31 + Arrays.hashCode(address);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof KeyUri)) {
                return false;
            }
            KeyUri key = (KeyUri)o;
            return this.uri.equals(key.uri) && this.port == key.port && Arrays.equals(this.address, key.address);
        }

        public String toString() {
            return "KeyUri[" + this.uri + ", " + Utils.toHexString(this.address) + ":" + this.port + "]";
        }
    }

    public static enum Origin {
        LOCAL,
        REMOTE;

    }
}

