/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Logger;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.network.stack.CoapStack;
import org.eclipse.californium.core.network.stack.Layer;
import org.eclipse.californium.core.server.MessageDeliverer;

public abstract class BaseCoapStack
implements CoapStack {
    private static final Logger LOGGER = Logger.getLogger(BaseCoapStack.class.getCanonicalName());
    private List<Layer> layers;
    private final Outbox outbox;
    private final StackTopAdapter top = new StackTopAdapter();
    private final StackBottomAdapter bottom = new StackBottomAdapter();
    private MessageDeliverer deliverer;

    protected BaseCoapStack(Outbox outbox) {
        this.outbox = outbox;
    }

    protected final void setLayers(Layer[] specificLayers) {
        Layer.TopDownBuilder builder = new Layer.TopDownBuilder().add(this.top);
        Layer[] layerArray = specificLayers;
        int n = specificLayers.length;
        int n2 = 0;
        while (n2 < n) {
            Layer layer = layerArray[n2];
            builder.add(layer);
            ++n2;
        }
        builder.add(this.bottom);
        this.layers = builder.create();
    }

    @Override
    public void sendRequest(Request request) {
        this.top.sendRequest(request);
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        this.top.sendResponse(exchange, response);
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.top.sendEmptyMessage(exchange, message);
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        this.bottom.receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        this.bottom.receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.bottom.receiveEmptyMessage(exchange, message);
    }

    @Override
    public final void setExecutor(ScheduledExecutorService executor) {
        for (Layer layer : this.layers) {
            layer.setExecutor(executor);
        }
    }

    @Override
    public final void setDeliverer(MessageDeliverer deliverer) {
        this.deliverer = deliverer;
    }

    @Override
    public final boolean hasDeliverer() {
        return this.deliverer != null;
    }

    @Override
    public void destroy() {
        for (Layer layer : this.layers) {
            layer.destroy();
        }
    }

    private class StackBottomAdapter
    extends AbstractLayer {
        private StackBottomAdapter() {
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            BaseCoapStack.this.outbox.sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            BaseCoapStack.this.outbox.sendResponse(exchange, response);
        }

        @Override
        public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
            BaseCoapStack.this.outbox.sendEmptyMessage(exchange, message);
        }
    }

    private class StackTopAdapter
    extends AbstractLayer {
        private StackTopAdapter() {
        }

        public void sendRequest(Request request) {
            Exchange exchange = new Exchange(request, Exchange.Origin.LOCAL);
            this.sendRequest(exchange, request);
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            exchange.setRequest(request);
            this.lower().sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            exchange.setResponse(response);
            this.lower().sendResponse(exchange, response);
        }

        @Override
        public void receiveRequest(Exchange exchange, Request request) {
            if (exchange.getRequest() == null) {
                exchange.setRequest(request);
            }
            if (BaseCoapStack.this.hasDeliverer()) {
                BaseCoapStack.this.deliverer.deliverRequest(exchange);
            } else {
                LOGGER.severe("Top of CoAP stack has no deliverer to deliver request");
            }
        }

        @Override
        public void receiveResponse(Exchange exchange, Response response) {
            if (!response.getOptions().hasObserve()) {
                exchange.setComplete();
            }
            if (BaseCoapStack.this.hasDeliverer()) {
                BaseCoapStack.this.deliverer.deliverResponse(exchange, response);
            } else {
                LOGGER.severe("Top of CoAP stack has no deliverer to deliver response");
            }
        }

        @Override
        public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        }
    }
}

