/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;

public interface Layer {
    public void sendRequest(Exchange var1, Request var2);

    public void sendResponse(Exchange var1, Response var2);

    public void sendEmptyMessage(Exchange var1, EmptyMessage var2);

    public void receiveRequest(Exchange var1, Request var2);

    public void receiveResponse(Exchange var1, Response var2);

    public void receiveEmptyMessage(Exchange var1, EmptyMessage var2);

    public void setLowerLayer(Layer var1);

    public void setUpperLayer(Layer var1);

    public void setExecutor(ScheduledExecutorService var1);

    public void destroy();

    public static final class TopDownBuilder {
        private final List<Layer> stack = new ArrayList<Layer>();
        private Layer bottom;

        public TopDownBuilder add(Layer layer) {
            if (this.bottom != null) {
                this.bottom.setLowerLayer(layer);
            }
            this.stack.add(layer);
            this.bottom = layer;
            return this;
        }

        public List<Layer> create() {
            return Collections.unmodifiableList(new ArrayList<Layer>(this.stack));
        }
    }
}

